// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Deidentification
{
    /// <summary> Request body for de-identification operation. </summary>
    public partial class DeidentificationContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeidentificationContent"/>. </summary>
        /// <param name="inputText"> Input text to de-identify. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="inputText"/> is null. </exception>
        public DeidentificationContent(string inputText)
        {
            Argument.AssertNotNull(inputText, nameof(inputText));

            InputText = inputText;
        }

        /// <summary> Initializes a new instance of <see cref="DeidentificationContent"/>. </summary>
        /// <param name="inputText"> Input text to de-identify. </param>
        /// <param name="operation"> Operation to perform on the input. </param>
        /// <param name="dataType"> Data type of the input. </param>
        /// <param name="redactionFormat"> Format of the redacted output. Only valid when OperationType is "Redact". </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeidentificationContent(string inputText, OperationType? operation, DocumentDataType? dataType, string redactionFormat, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InputText = inputText;
            Operation = operation;
            DataType = dataType;
            RedactionFormat = redactionFormat;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeidentificationContent"/> for deserialization. </summary>
        internal DeidentificationContent()
        {
        }

        /// <summary> Input text to de-identify. </summary>
        public string InputText { get; }
        /// <summary> Operation to perform on the input. </summary>
        public OperationType? Operation { get; set; }
        /// <summary> Data type of the input. </summary>
        public DocumentDataType? DataType { get; set; }
        /// <summary> Format of the redacted output. Only valid when OperationType is "Redact". </summary>
        public string RedactionFormat { get; set; }
    }
}
