// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Health.Deidentification
{
    /// <summary> Client options for DeidentificationClient. </summary>
    public partial class DeidentificationClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2024_07_12_Preview;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2024-07-12-preview". </summary>
            V2024_07_12_Preview = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of DeidentificationClientOptions. </summary>
        public DeidentificationClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2024_07_12_Preview => "2024-07-12-preview",
                _ => throw new NotSupportedException()
            };
        }
    }
}
