// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> An object to configure an identity provider for use with SMART on FHIR authentication. </summary>
    public partial class SmartIdentityProviderConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SmartIdentityProviderConfiguration"/>. </summary>
        public SmartIdentityProviderConfiguration()
        {
            Applications = new ChangeTrackingList<SmartIdentityProviderApplication>();
        }

        /// <summary> Initializes a new instance of <see cref="SmartIdentityProviderConfiguration"/>. </summary>
        /// <param name="authority"> The identity provider token authority also known as the token issuing authority. </param>
        /// <param name="applications"> The array of identity provider applications for SMART on FHIR authentication. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SmartIdentityProviderConfiguration(string authority, IList<SmartIdentityProviderApplication> applications, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Authority = authority;
            Applications = applications;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The identity provider token authority also known as the token issuing authority. </summary>
        public string Authority { get; set; }
        /// <summary> The array of identity provider applications for SMART on FHIR authentication. </summary>
        public IList<SmartIdentityProviderApplication> Applications { get; }
    }
}
