// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> An Application configured in the Identity Provider used to access FHIR resources. </summary>
    public partial class SmartIdentityProviderApplication
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SmartIdentityProviderApplication"/>. </summary>
        public SmartIdentityProviderApplication()
        {
            AllowedDataActions = new ChangeTrackingList<SmartDataAction>();
        }

        /// <summary> Initializes a new instance of <see cref="SmartIdentityProviderApplication"/>. </summary>
        /// <param name="clientId"> The application client id defined in the identity provider. This value will be used to validate bearer tokens against the given authority. </param>
        /// <param name="audience"> The audience that will be used to validate bearer tokens against the given authority. </param>
        /// <param name="allowedDataActions"> The actions that are permitted to be performed on FHIR resources for the application. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SmartIdentityProviderApplication(string clientId, string audience, IList<SmartDataAction> allowedDataActions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientId = clientId;
            Audience = audience;
            AllowedDataActions = allowedDataActions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The application client id defined in the identity provider. This value will be used to validate bearer tokens against the given authority. </summary>
        public string ClientId { get; set; }
        /// <summary> The audience that will be used to validate bearer tokens against the given authority. </summary>
        public string Audience { get; set; }
        /// <summary> The actions that are permitted to be performed on FHIR resources for the application. </summary>
        public IList<SmartDataAction> AllowedDataActions { get; }
    }
}
