// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    public partial class SmartIdentityProviderApplication : IUtf8JsonSerializable, IJsonModel<SmartIdentityProviderApplication>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SmartIdentityProviderApplication>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SmartIdentityProviderApplication>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartIdentityProviderApplication>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SmartIdentityProviderApplication)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ClientId))
            {
                writer.WritePropertyName("clientId"u8);
                writer.WriteStringValue(ClientId);
            }
            if (Optional.IsDefined(Audience))
            {
                writer.WritePropertyName("audience"u8);
                writer.WriteStringValue(Audience);
            }
            if (Optional.IsCollectionDefined(AllowedDataActions))
            {
                writer.WritePropertyName("allowedDataActions"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedDataActions)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SmartIdentityProviderApplication IJsonModel<SmartIdentityProviderApplication>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartIdentityProviderApplication>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SmartIdentityProviderApplication)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSmartIdentityProviderApplication(document.RootElement, options);
        }

        internal static SmartIdentityProviderApplication DeserializeSmartIdentityProviderApplication(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clientId = default;
            string audience = default;
            IList<SmartDataAction> allowedDataActions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clientId"u8))
                {
                    clientId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("audience"u8))
                {
                    audience = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("allowedDataActions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SmartDataAction> array = new List<SmartDataAction>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new SmartDataAction(item.GetString()));
                    }
                    allowedDataActions = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SmartIdentityProviderApplication(clientId, audience, allowedDataActions ?? new ChangeTrackingList<SmartDataAction>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SmartIdentityProviderApplication>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartIdentityProviderApplication>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SmartIdentityProviderApplication)} does not support writing '{options.Format}' format.");
            }
        }

        SmartIdentityProviderApplication IPersistableModel<SmartIdentityProviderApplication>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartIdentityProviderApplication>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSmartIdentityProviderApplication(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SmartIdentityProviderApplication)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SmartIdentityProviderApplication>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
