// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> The Data Actions that can be enabled for a Smart Identity Provider Application. </summary>
    public readonly partial struct SmartDataAction : IEquatable<SmartDataAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SmartDataAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SmartDataAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadValue = "Read";

        /// <summary> Read. </summary>
        public static SmartDataAction Read { get; } = new SmartDataAction(ReadValue);
        /// <summary> Determines if two <see cref="SmartDataAction"/> values are the same. </summary>
        public static bool operator ==(SmartDataAction left, SmartDataAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SmartDataAction"/> values are not the same. </summary>
        public static bool operator !=(SmartDataAction left, SmartDataAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SmartDataAction"/>. </summary>
        public static implicit operator SmartDataAction(string value) => new SmartDataAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SmartDataAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SmartDataAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
