// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> An Open Container Initiative (OCI) artifact. </summary>
    public partial class HealthcareApisServiceOciArtifactEntry
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HealthcareApisServiceOciArtifactEntry"/>. </summary>
        public HealthcareApisServiceOciArtifactEntry()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HealthcareApisServiceOciArtifactEntry"/>. </summary>
        /// <param name="loginServer"> The Azure Container Registry login server. </param>
        /// <param name="imageName"> The artifact name. </param>
        /// <param name="digest"> The artifact digest. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HealthcareApisServiceOciArtifactEntry(string loginServer, string imageName, string digest, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LoginServer = loginServer;
            ImageName = imageName;
            Digest = digest;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure Container Registry login server. </summary>
        public string LoginServer { get; set; }
        /// <summary> The artifact name. </summary>
        public string ImageName { get; set; }
        /// <summary> The artifact digest. </summary>
        public string Digest { get; set; }
    }
}
