// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> Control permission for data plane traffic coming from public networks while private endpoint is enabled. </summary>
    public readonly partial struct HealthcareApisPublicNetworkAccess : IEquatable<HealthcareApisPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthcareApisPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthcareApisPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static HealthcareApisPublicNetworkAccess Enabled { get; } = new HealthcareApisPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static HealthcareApisPublicNetworkAccess Disabled { get; } = new HealthcareApisPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="HealthcareApisPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(HealthcareApisPublicNetworkAccess left, HealthcareApisPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthcareApisPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(HealthcareApisPublicNetworkAccess left, HealthcareApisPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthcareApisPublicNetworkAccess"/>. </summary>
        public static implicit operator HealthcareApisPublicNetworkAccess(string value) => new HealthcareApisPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthcareApisPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthcareApisPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
