// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct HealthcareApisPrivateEndpointConnectionProvisioningState : IEquatable<HealthcareApisPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthcareApisPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthcareApisPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static HealthcareApisPrivateEndpointConnectionProvisioningState Succeeded { get; } = new HealthcareApisPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static HealthcareApisPrivateEndpointConnectionProvisioningState Creating { get; } = new HealthcareApisPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static HealthcareApisPrivateEndpointConnectionProvisioningState Deleting { get; } = new HealthcareApisPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static HealthcareApisPrivateEndpointConnectionProvisioningState Failed { get; } = new HealthcareApisPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="HealthcareApisPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(HealthcareApisPrivateEndpointConnectionProvisioningState left, HealthcareApisPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthcareApisPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(HealthcareApisPrivateEndpointConnectionProvisioningState left, HealthcareApisPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthcareApisPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator HealthcareApisPrivateEndpointConnectionProvisioningState(string value) => new HealthcareApisPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthcareApisPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthcareApisPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
