// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    internal static partial class HealthcareApisNameUnavailableReasonExtensions
    {
        public static string ToSerialString(this HealthcareApisNameUnavailableReason value) => value switch
        {
            HealthcareApisNameUnavailableReason.Invalid => "Invalid",
            HealthcareApisNameUnavailableReason.AlreadyExists => "AlreadyExists",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareApisNameUnavailableReason value.")
        };

        public static HealthcareApisNameUnavailableReason ToHealthcareApisNameUnavailableReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return HealthcareApisNameUnavailableReason.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AlreadyExists")) return HealthcareApisNameUnavailableReason.AlreadyExists;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareApisNameUnavailableReason value.");
        }
    }
}
