// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> The type of IoT identity resolution to use with the destination. </summary>
    public readonly partial struct HealthcareApisIotIdentityResolutionType : IEquatable<HealthcareApisIotIdentityResolutionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthcareApisIotIdentityResolutionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthcareApisIotIdentityResolutionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreateValue = "Create";
        private const string LookupValue = "Lookup";

        /// <summary> Create. </summary>
        public static HealthcareApisIotIdentityResolutionType Create { get; } = new HealthcareApisIotIdentityResolutionType(CreateValue);
        /// <summary> Lookup. </summary>
        public static HealthcareApisIotIdentityResolutionType Lookup { get; } = new HealthcareApisIotIdentityResolutionType(LookupValue);
        /// <summary> Determines if two <see cref="HealthcareApisIotIdentityResolutionType"/> values are the same. </summary>
        public static bool operator ==(HealthcareApisIotIdentityResolutionType left, HealthcareApisIotIdentityResolutionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthcareApisIotIdentityResolutionType"/> values are not the same. </summary>
        public static bool operator !=(HealthcareApisIotIdentityResolutionType left, HealthcareApisIotIdentityResolutionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthcareApisIotIdentityResolutionType"/>. </summary>
        public static implicit operator HealthcareApisIotIdentityResolutionType(string value) => new HealthcareApisIotIdentityResolutionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthcareApisIotIdentityResolutionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthcareApisIotIdentityResolutionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
