// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> The settings for history tracking for FHIR resources. </summary>
    public partial class FhirServiceResourceVersionPolicyConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FhirServiceResourceVersionPolicyConfiguration"/>. </summary>
        public FhirServiceResourceVersionPolicyConfiguration()
        {
            ResourceTypeOverrides = new ChangeTrackingDictionary<string, FhirResourceVersionPolicy>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirServiceResourceVersionPolicyConfiguration"/>. </summary>
        /// <param name="default"> The default value for tracking history across all resources. </param>
        /// <param name="resourceTypeOverrides"> A list of FHIR Resources and their version policy overrides. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FhirServiceResourceVersionPolicyConfiguration(FhirResourceVersionPolicy? @default, IDictionary<string, FhirResourceVersionPolicy> resourceTypeOverrides, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Default = @default;
            ResourceTypeOverrides = resourceTypeOverrides;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The default value for tracking history across all resources. </summary>
        public FhirResourceVersionPolicy? Default { get; set; }
        /// <summary> A list of FHIR Resources and their version policy overrides. </summary>
        public IDictionary<string, FhirResourceVersionPolicy> ResourceTypeOverrides { get; }
    }
}
