// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> Import operation configuration information. </summary>
    public partial class FhirServiceImportConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FhirServiceImportConfiguration"/>. </summary>
        public FhirServiceImportConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FhirServiceImportConfiguration"/>. </summary>
        /// <param name="integrationDataStore"> The name of the default integration storage account. </param>
        /// <param name="isInitialImportMode"> If the FHIR service is in InitialImportMode. </param>
        /// <param name="isEnabled"> If the import operation is enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FhirServiceImportConfiguration(string integrationDataStore, bool? isInitialImportMode, bool? isEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IntegrationDataStore = integrationDataStore;
            IsInitialImportMode = isInitialImportMode;
            IsEnabled = isEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the default integration storage account. </summary>
        public string IntegrationDataStore { get; set; }
        /// <summary> If the FHIR service is in InitialImportMode. </summary>
        public bool? IsInitialImportMode { get; set; }
        /// <summary> If the import operation is enabled. </summary>
        public bool? IsEnabled { get; set; }
    }
}
