// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthcareApis.Models
{
    /// <summary> Indicates the current status of event support for the resource. </summary>
    public readonly partial struct FhirServiceEventState : IEquatable<FhirServiceEventState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FhirServiceEventState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FhirServiceEventState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";
        private const string UpdatingValue = "Updating";

        /// <summary> Disabled. </summary>
        public static FhirServiceEventState Disabled { get; } = new FhirServiceEventState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static FhirServiceEventState Enabled { get; } = new FhirServiceEventState(EnabledValue);
        /// <summary> Updating. </summary>
        public static FhirServiceEventState Updating { get; } = new FhirServiceEventState(UpdatingValue);
        /// <summary> Determines if two <see cref="FhirServiceEventState"/> values are the same. </summary>
        public static bool operator ==(FhirServiceEventState left, FhirServiceEventState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FhirServiceEventState"/> values are not the same. </summary>
        public static bool operator !=(FhirServiceEventState left, FhirServiceEventState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FhirServiceEventState"/>. </summary>
        public static implicit operator FhirServiceEventState(string value) => new FhirServiceEventState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FhirServiceEventState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FhirServiceEventState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
