// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HealthcareApis
{
    internal class HealthcareApisWorkspaceOperationSource : IOperationSource<HealthcareApisWorkspaceResource>
    {
        private readonly ArmClient _client;

        internal HealthcareApisWorkspaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        HealthcareApisWorkspaceResource IOperationSource<HealthcareApisWorkspaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HealthcareApisWorkspaceData.DeserializeHealthcareApisWorkspaceData(document.RootElement);
            return new HealthcareApisWorkspaceResource(_client, data);
        }

        async ValueTask<HealthcareApisWorkspaceResource> IOperationSource<HealthcareApisWorkspaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HealthcareApisWorkspaceData.DeserializeHealthcareApisWorkspaceData(document.RootElement);
            return new HealthcareApisWorkspaceResource(_client, data);
        }
    }
}
