// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HealthcareApis
{
    internal class HealthcareApisServiceOperationSource : IOperationSource<HealthcareApisServiceResource>
    {
        private readonly ArmClient _client;

        internal HealthcareApisServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        HealthcareApisServiceResource IOperationSource<HealthcareApisServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HealthcareApisServiceData.DeserializeHealthcareApisServiceData(document.RootElement);
            return new HealthcareApisServiceResource(_client, data);
        }

        async ValueTask<HealthcareApisServiceResource> IOperationSource<HealthcareApisServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HealthcareApisServiceData.DeserializeHealthcareApisServiceData(document.RootElement);
            return new HealthcareApisServiceResource(_client, data);
        }
    }
}
