// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HealthcareApis
{
    internal class HealthcareApisIotConnectorOperationSource : IOperationSource<HealthcareApisIotConnectorResource>
    {
        private readonly ArmClient _client;

        internal HealthcareApisIotConnectorOperationSource(ArmClient client)
        {
            _client = client;
        }

        HealthcareApisIotConnectorResource IOperationSource<HealthcareApisIotConnectorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HealthcareApisIotConnectorData.DeserializeHealthcareApisIotConnectorData(document.RootElement);
            return new HealthcareApisIotConnectorResource(_client, data);
        }

        async ValueTask<HealthcareApisIotConnectorResource> IOperationSource<HealthcareApisIotConnectorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HealthcareApisIotConnectorData.DeserializeHealthcareApisIotConnectorData(document.RootElement);
            return new HealthcareApisIotConnectorResource(_client, data);
        }
    }
}
