// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HealthcareApis
{
    internal class DicomServiceOperationSource : IOperationSource<DicomServiceResource>
    {
        private readonly ArmClient _client;

        internal DicomServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        DicomServiceResource IOperationSource<DicomServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DicomServiceData.DeserializeDicomServiceData(document.RootElement);
            return new DicomServiceResource(_client, data);
        }

        async ValueTask<DicomServiceResource> IOperationSource<DicomServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DicomServiceData.DeserializeDicomServiceData(document.RootElement);
            return new DicomServiceResource(_client, data);
        }
    }
}
