// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.HealthcareApis.Samples
{
    public partial class Sample_HealthcareApisServicePrivateLinkResource
    {
        // PrivateLinkResources_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PrivateLinkResourcesGet()
        {
            // Generated from example definition: specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2024-03-31/examples/legacy/PrivateLinkResourceGet.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HealthcareApisServicePrivateLinkResource created on azure
            // for more information of creating HealthcareApisServicePrivateLinkResource, please refer to the document of HealthcareApisServicePrivateLinkResource
            string subscriptionId = "subid";
            string resourceGroupName = "rgname";
            string resourceName = "service1";
            string groupName = "fhir";
            ResourceIdentifier healthcareApisServicePrivateLinkResourceId = HealthcareApisServicePrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, groupName);
            HealthcareApisServicePrivateLinkResource healthcareApisServicePrivateLinkResource = client.GetHealthcareApisServicePrivateLinkResource(healthcareApisServicePrivateLinkResourceId);

            // invoke the operation
            HealthcareApisServicePrivateLinkResource result = await healthcareApisServicePrivateLinkResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HealthcareApisPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
