// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.HealthBot.Models
{
    internal static partial class HealthBotSkuNameExtensions
    {
        public static string ToSerialString(this HealthBotSkuName value) => value switch
        {
            HealthBotSkuName.F0 => "F0",
            HealthBotSkuName.S1 => "S1",
            HealthBotSkuName.C0 => "C0",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthBotSkuName value.")
        };

        public static HealthBotSkuName ToHealthBotSkuName(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "F0")) return HealthBotSkuName.F0;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "S1")) return HealthBotSkuName.S1;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "C0")) return HealthBotSkuName.C0;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthBotSkuName value.");
        }
    }
}
