// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.HealthBot.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableHealthBotArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableHealthBotArmClient"/> class for mocking. </summary>
        protected MockableHealthBotArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableHealthBotArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableHealthBotArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableHealthBotArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="HealthBotResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HealthBotResource.CreateResourceIdentifier" /> to create a <see cref="HealthBotResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HealthBotResource"/> object. </returns>
        public virtual HealthBotResource GetHealthBotResource(ResourceIdentifier id)
        {
            HealthBotResource.ValidateResourceId(id);
            return new HealthBotResource(Client, id);
        }
    }
}
