// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Unknown version of ClusterLibraryProperties. </summary>
    internal partial class UnknownClusterLibraryProperties : ClusterLibraryProperties
    {
        /// <summary> Initializes a new instance of <see cref="UnknownClusterLibraryProperties"/>. </summary>
        /// <param name="libraryType"> Type of the library. </param>
        /// <param name="remarks"> Remark of the latest library management operation. </param>
        /// <param name="timestamp"> Timestamp of the latest library management operation. </param>
        /// <param name="status"> Status of the library. </param>
        /// <param name="message"> Error message of the library operation when a failure occurs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownClusterLibraryProperties(Type libraryType, string remarks, DateTimeOffset? timestamp, Status? status, string message, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(libraryType, remarks, timestamp, status, message, serializedAdditionalRawData)
        {
            LibraryType = libraryType;
        }

        /// <summary> Initializes a new instance of <see cref="UnknownClusterLibraryProperties"/> for deserialization. </summary>
        internal UnknownClusterLibraryProperties()
        {
        }
    }
}
