// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Trino user plugin. </summary>
    public partial class TrinoUserPlugin
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TrinoUserPlugin"/>. </summary>
        public TrinoUserPlugin()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TrinoUserPlugin"/>. </summary>
        /// <param name="isEnabled"> Denotes whether the plugin is active or not. </param>
        /// <param name="name"> This field maps to the sub-directory in trino plugins location, that will contain all the plugins under path. </param>
        /// <param name="path"> Fully qualified path to the folder containing the plugins. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TrinoUserPlugin(bool? isEnabled, string name, string path, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            Name = name;
            Path = path;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Denotes whether the plugin is active or not. </summary>
        [WirePath("enabled")]
        public bool? IsEnabled { get; set; }
        /// <summary> This field maps to the sub-directory in trino plugins location, that will contain all the plugins under path. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Fully qualified path to the folder containing the plugins. </summary>
        [WirePath("path")]
        public string Path { get; set; }
    }
}
