// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Trino Cluster profile. </summary>
    public partial class TrinoProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TrinoProfile"/>. </summary>
        public TrinoProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TrinoProfile"/>. </summary>
        /// <param name="catalogOptions"> Trino cluster catalog options. </param>
        /// <param name="coordinator"> Trino Coordinator. </param>
        /// <param name="userPluginsSpec"> Trino user plugins spec. </param>
        /// <param name="userTelemetrySpec"> User telemetry. </param>
        /// <param name="worker"> Trino worker. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TrinoProfile(CatalogOptions catalogOptions, TrinoCoordinator coordinator, TrinoUserPluginListResult userPluginsSpec, TrinoUserTelemetry userTelemetrySpec, TrinoWorker worker, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CatalogOptions = catalogOptions;
            Coordinator = coordinator;
            UserPluginsSpec = userPluginsSpec;
            UserTelemetrySpec = userTelemetrySpec;
            Worker = worker;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Trino cluster catalog options. </summary>
        internal CatalogOptions CatalogOptions { get; set; }
        /// <summary> hive catalog options. </summary>
        [WirePath("catalogOptions.hive")]
        public IList<HiveCatalogOption> CatalogOptionsHive
        {
            get
            {
                if (CatalogOptions is null)
                    CatalogOptions = new CatalogOptions();
                return CatalogOptions.Hive;
            }
        }

        /// <summary> Trino Coordinator. </summary>
        [WirePath("coordinator")]
        public TrinoCoordinator Coordinator { get; set; }
        /// <summary> Trino user plugins spec. </summary>
        internal TrinoUserPluginListResult UserPluginsSpec { get; set; }
        /// <summary> Trino user plugins. </summary>
        [WirePath("userPluginsSpec.plugins")]
        public IList<TrinoUserPlugin> Plugins
        {
            get
            {
                if (UserPluginsSpec is null)
                    UserPluginsSpec = new TrinoUserPluginListResult();
                return UserPluginsSpec.Plugins;
            }
        }

        /// <summary> User telemetry. </summary>
        internal TrinoUserTelemetry UserTelemetrySpec { get; set; }
        /// <summary> Trino user telemetry definition. </summary>
        [WirePath("userTelemetrySpec.storage")]
        public TrinoTelemetryConfig UserTelemetrySpecStorage
        {
            get => UserTelemetrySpec is null ? default : UserTelemetrySpec.Storage;
            set
            {
                if (UserTelemetrySpec is null)
                    UserTelemetrySpec = new TrinoUserTelemetry();
                UserTelemetrySpec.Storage = value;
            }
        }

        /// <summary> Trino worker. </summary>
        internal TrinoWorker Worker { get; set; }
        /// <summary> Trino debug configuration. </summary>
        [WirePath("worker.debug")]
        public TrinoDebugConfig WorkerDebug
        {
            get => Worker is null ? default : Worker.Debug;
            set
            {
                if (Worker is null)
                    Worker = new TrinoWorker();
                Worker.Debug = value;
            }
        }
    }
}
