// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class TrinoProfile : IUtf8JsonSerializable, IJsonModel<TrinoProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<TrinoProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<TrinoProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TrinoProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TrinoProfile)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CatalogOptions))
            {
                writer.WritePropertyName("catalogOptions"u8);
                writer.WriteObjectValue(CatalogOptions, options);
            }
            if (Optional.IsDefined(Coordinator))
            {
                writer.WritePropertyName("coordinator"u8);
                writer.WriteObjectValue(Coordinator, options);
            }
            if (Optional.IsDefined(UserPluginsSpec))
            {
                writer.WritePropertyName("userPluginsSpec"u8);
                writer.WriteObjectValue(UserPluginsSpec, options);
            }
            if (Optional.IsDefined(UserTelemetrySpec))
            {
                writer.WritePropertyName("userTelemetrySpec"u8);
                writer.WriteObjectValue(UserTelemetrySpec, options);
            }
            if (Optional.IsDefined(Worker))
            {
                writer.WritePropertyName("worker"u8);
                writer.WriteObjectValue(Worker, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        TrinoProfile IJsonModel<TrinoProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TrinoProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TrinoProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeTrinoProfile(document.RootElement, options);
        }

        internal static TrinoProfile DeserializeTrinoProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CatalogOptions catalogOptions = default;
            TrinoCoordinator coordinator = default;
            TrinoUserPluginListResult userPluginsSpec = default;
            TrinoUserTelemetry userTelemetrySpec = default;
            TrinoWorker worker = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("catalogOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    catalogOptions = CatalogOptions.DeserializeCatalogOptions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("coordinator"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    coordinator = TrinoCoordinator.DeserializeTrinoCoordinator(property.Value, options);
                    continue;
                }
                if (property.NameEquals("userPluginsSpec"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    userPluginsSpec = TrinoUserPluginListResult.DeserializeTrinoUserPluginListResult(property.Value, options);
                    continue;
                }
                if (property.NameEquals("userTelemetrySpec"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    userTelemetrySpec = TrinoUserTelemetry.DeserializeTrinoUserTelemetry(property.Value, options);
                    continue;
                }
                if (property.NameEquals("worker"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    worker = TrinoWorker.DeserializeTrinoWorker(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new TrinoProfile(
                catalogOptions,
                coordinator,
                userPluginsSpec,
                userTelemetrySpec,
                worker,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("CatalogOptionsHive", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  catalogOptions: ");
                builder.AppendLine("{");
                builder.Append("    hive: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(CatalogOptions))
                {
                    builder.Append("  catalogOptions: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CatalogOptions, options, 2, false, "  catalogOptions: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Coordinator), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  coordinator: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Coordinator))
                {
                    builder.Append("  coordinator: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Coordinator, options, 2, false, "  coordinator: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("Plugins", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  userPluginsSpec: ");
                builder.AppendLine("{");
                builder.Append("    plugins: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(UserPluginsSpec))
                {
                    builder.Append("  userPluginsSpec: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UserPluginsSpec, options, 2, false, "  userPluginsSpec: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("UserTelemetrySpecStorage", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  userTelemetrySpec: ");
                builder.AppendLine("{");
                builder.Append("    storage: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(UserTelemetrySpec))
                {
                    builder.Append("  userTelemetrySpec: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UserTelemetrySpec, options, 2, false, "  userTelemetrySpec: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("WorkerDebug", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  worker: ");
                builder.AppendLine("{");
                builder.Append("    debug: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(Worker))
                {
                    builder.Append("  worker: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Worker, options, 2, false, "  worker: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<TrinoProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TrinoProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(TrinoProfile)} does not support writing '{options.Format}' format.");
            }
        }

        TrinoProfile IPersistableModel<TrinoProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TrinoProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeTrinoProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(TrinoProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<TrinoProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
