// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Status of the library. </summary>
    public readonly partial struct Status : IEquatable<Status>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="Status"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public Status(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstallingValue = "INSTALLING";
        private const string InstalledValue = "INSTALLED";
        private const string InstallFailedValue = "INSTALL_FAILED";
        private const string UninstallingValue = "UNINSTALLING";
        private const string UninstallFailedValue = "UNINSTALL_FAILED";

        /// <summary> INSTALLING. </summary>
        public static Status Installing { get; } = new Status(InstallingValue);
        /// <summary> INSTALLED. </summary>
        public static Status Installed { get; } = new Status(InstalledValue);
        /// <summary> INSTALL_FAILED. </summary>
        public static Status InstallFailed { get; } = new Status(InstallFailedValue);
        /// <summary> UNINSTALLING. </summary>
        public static Status Uninstalling { get; } = new Status(UninstallingValue);
        /// <summary> UNINSTALL_FAILED. </summary>
        public static Status UninstallFailed { get; } = new Status(UninstallFailedValue);
        /// <summary> Determines if two <see cref="Status"/> values are the same. </summary>
        public static bool operator ==(Status left, Status right) => left.Equals(right);
        /// <summary> Determines if two <see cref="Status"/> values are not the same. </summary>
        public static bool operator !=(Status left, Status right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="Status"/>. </summary>
        public static implicit operator Status(string value) => new Status(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is Status other && Equals(other);
        /// <inheritdoc />
        public bool Equals(Status other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
