// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Spark user plugins spec. </summary>
    internal partial class SparkUserPluginListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SparkUserPluginListResult"/>. </summary>
        public SparkUserPluginListResult()
        {
            Plugins = new ChangeTrackingList<SparkUserPlugin>();
        }

        /// <summary> Initializes a new instance of <see cref="SparkUserPluginListResult"/>. </summary>
        /// <param name="plugins"> Spark user plugins. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SparkUserPluginListResult(IList<SparkUserPlugin> plugins, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Plugins = plugins;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Spark user plugins. </summary>
        [WirePath("plugins")]
        public IList<SparkUserPlugin> Plugins { get; }
    }
}
