// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The spark cluster profile. </summary>
    public partial class SparkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SparkProfile"/>. </summary>
        public SparkProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SparkProfile"/>. </summary>
        /// <param name="defaultStorageUriString"> The default storage URL. </param>
        /// <param name="metastoreSpec"> The metastore specification for Spark cluster. </param>
        /// <param name="userPluginsSpec"> Spark user plugins spec. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SparkProfile(string defaultStorageUriString, SparkMetastoreSpec metastoreSpec, SparkUserPluginListResult userPluginsSpec, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DefaultStorageUriString = defaultStorageUriString;
            MetastoreSpec = metastoreSpec;
            UserPluginsSpec = userPluginsSpec;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The default storage URL. </summary>
        [WirePath("defaultStorageUrl")]
        public string DefaultStorageUriString { get; set; }
        /// <summary> The metastore specification for Spark cluster. </summary>
        [WirePath("metastoreSpec")]
        public SparkMetastoreSpec MetastoreSpec { get; set; }
        /// <summary> Spark user plugins spec. </summary>
        internal SparkUserPluginListResult UserPluginsSpec { get; set; }
        /// <summary> Spark user plugins. </summary>
        [WirePath("userPluginsSpec.plugins")]
        public IList<SparkUserPlugin> Plugins
        {
            get
            {
                if (UserPluginsSpec is null)
                    UserPluginsSpec = new SparkUserPluginListResult();
                return UserPluginsSpec.Plugins;
            }
        }
    }
}
