// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The metastore specification for Spark cluster. </summary>
    public partial class SparkMetastoreSpec
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SparkMetastoreSpec"/>. </summary>
        /// <param name="dbServerHost"> The database server host. </param>
        /// <param name="dbName"> The database name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dbServerHost"/> or <paramref name="dbName"/> is null. </exception>
        public SparkMetastoreSpec(string dbServerHost, string dbName)
        {
            Argument.AssertNotNull(dbServerHost, nameof(dbServerHost));
            Argument.AssertNotNull(dbName, nameof(dbName));

            DBServerHost = dbServerHost;
            DBName = dbName;
        }

        /// <summary> Initializes a new instance of <see cref="SparkMetastoreSpec"/>. </summary>
        /// <param name="dbServerHost"> The database server host. </param>
        /// <param name="dbName"> The database name. </param>
        /// <param name="dbConnectionAuthenticationMode"> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </param>
        /// <param name="dbUserName"> The database user name. </param>
        /// <param name="dbPasswordSecretName"> The secret name which contains the database user password. </param>
        /// <param name="keyVaultId"> The key vault resource id. </param>
        /// <param name="thriftUriString"> The thrift url. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SparkMetastoreSpec(string dbServerHost, string dbName, DBConnectionAuthenticationMode? dbConnectionAuthenticationMode, string dbUserName, string dbPasswordSecretName, string keyVaultId, string thriftUriString, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DBServerHost = dbServerHost;
            DBName = dbName;
            DBConnectionAuthenticationMode = dbConnectionAuthenticationMode;
            DBUserName = dbUserName;
            DBPasswordSecretName = dbPasswordSecretName;
            KeyVaultId = keyVaultId;
            ThriftUriString = thriftUriString;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SparkMetastoreSpec"/> for deserialization. </summary>
        internal SparkMetastoreSpec()
        {
        }

        /// <summary> The database server host. </summary>
        [WirePath("dbServerHost")]
        public string DBServerHost { get; set; }
        /// <summary> The database name. </summary>
        [WirePath("dbName")]
        public string DBName { get; set; }
        /// <summary> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </summary>
        [WirePath("dbConnectionAuthenticationMode")]
        public DBConnectionAuthenticationMode? DBConnectionAuthenticationMode { get; set; }
        /// <summary> The database user name. </summary>
        [WirePath("dbUserName")]
        public string DBUserName { get; set; }
        /// <summary> The secret name which contains the database user password. </summary>
        [WirePath("dbPasswordSecretName")]
        public string DBPasswordSecretName { get; set; }
        /// <summary> The key vault resource id. </summary>
        [WirePath("keyVaultId")]
        public string KeyVaultId { get; set; }
        /// <summary> The thrift url. </summary>
        [WirePath("thriftUrl")]
        public string ThriftUriString { get; set; }
    }
}
