// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class SparkMetastoreSpec : IUtf8JsonSerializable, IJsonModel<SparkMetastoreSpec>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SparkMetastoreSpec>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SparkMetastoreSpec>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkMetastoreSpec>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SparkMetastoreSpec)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("dbServerHost"u8);
            writer.WriteStringValue(DBServerHost);
            writer.WritePropertyName("dbName"u8);
            writer.WriteStringValue(DBName);
            if (Optional.IsDefined(DBConnectionAuthenticationMode))
            {
                writer.WritePropertyName("dbConnectionAuthenticationMode"u8);
                writer.WriteStringValue(DBConnectionAuthenticationMode.Value.ToString());
            }
            if (Optional.IsDefined(DBUserName))
            {
                writer.WritePropertyName("dbUserName"u8);
                writer.WriteStringValue(DBUserName);
            }
            if (Optional.IsDefined(DBPasswordSecretName))
            {
                writer.WritePropertyName("dbPasswordSecretName"u8);
                writer.WriteStringValue(DBPasswordSecretName);
            }
            if (Optional.IsDefined(KeyVaultId))
            {
                writer.WritePropertyName("keyVaultId"u8);
                writer.WriteStringValue(KeyVaultId);
            }
            if (Optional.IsDefined(ThriftUriString))
            {
                writer.WritePropertyName("thriftUrl"u8);
                writer.WriteStringValue(ThriftUriString);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SparkMetastoreSpec IJsonModel<SparkMetastoreSpec>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkMetastoreSpec>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SparkMetastoreSpec)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSparkMetastoreSpec(document.RootElement, options);
        }

        internal static SparkMetastoreSpec DeserializeSparkMetastoreSpec(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string dbServerHost = default;
            string dbName = default;
            DBConnectionAuthenticationMode? dbConnectionAuthenticationMode = default;
            string dbUserName = default;
            string dbPasswordSecretName = default;
            string keyVaultId = default;
            string thriftUrl = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dbServerHost"u8))
                {
                    dbServerHost = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dbName"u8))
                {
                    dbName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dbConnectionAuthenticationMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dbConnectionAuthenticationMode = new DBConnectionAuthenticationMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dbUserName"u8))
                {
                    dbUserName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dbPasswordSecretName"u8))
                {
                    dbPasswordSecretName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("keyVaultId"u8))
                {
                    keyVaultId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("thriftUrl"u8))
                {
                    thriftUrl = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SparkMetastoreSpec(
                dbServerHost,
                dbName,
                dbConnectionAuthenticationMode,
                dbUserName,
                dbPasswordSecretName,
                keyVaultId,
                thriftUrl,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DBServerHost), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dbServerHost: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DBServerHost))
                {
                    builder.Append("  dbServerHost: ");
                    if (DBServerHost.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DBServerHost}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DBServerHost}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DBName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dbName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DBName))
                {
                    builder.Append("  dbName: ");
                    if (DBName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DBName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DBName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DBConnectionAuthenticationMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dbConnectionAuthenticationMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DBConnectionAuthenticationMode))
                {
                    builder.Append("  dbConnectionAuthenticationMode: ");
                    builder.AppendLine($"'{DBConnectionAuthenticationMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DBUserName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dbUserName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DBUserName))
                {
                    builder.Append("  dbUserName: ");
                    if (DBUserName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DBUserName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DBUserName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DBPasswordSecretName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dbPasswordSecretName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DBPasswordSecretName))
                {
                    builder.Append("  dbPasswordSecretName: ");
                    if (DBPasswordSecretName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DBPasswordSecretName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DBPasswordSecretName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KeyVaultId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  keyVaultId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KeyVaultId))
                {
                    builder.Append("  keyVaultId: ");
                    if (KeyVaultId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{KeyVaultId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{KeyVaultId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ThriftUriString), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  thriftUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ThriftUriString))
                {
                    builder.Append("  thriftUrl: ");
                    if (ThriftUriString.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ThriftUriString}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ThriftUriString}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SparkMetastoreSpec>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkMetastoreSpec>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SparkMetastoreSpec)} does not support writing '{options.Format}' format.");
            }
        }

        SparkMetastoreSpec IPersistableModel<SparkMetastoreSpec>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkMetastoreSpec>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSparkMetastoreSpec(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SparkMetastoreSpec)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SparkMetastoreSpec>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
