// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The scaling rule. </summary>
    public partial class ScalingRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScalingRule"/>. </summary>
        /// <param name="actionType"> The action type. </param>
        /// <param name="evaluationCount"> This is an evaluation count for a scaling condition, the number of times a trigger condition should be successful, before scaling activity is triggered. </param>
        /// <param name="scalingMetric"> Metrics name for individual workloads. For example: cpu. </param>
        /// <param name="comparisonRule"> The comparison rule. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scalingMetric"/> or <paramref name="comparisonRule"/> is null. </exception>
        public ScalingRule(ScaleActionType actionType, int evaluationCount, string scalingMetric, HDInsightComparisonRule comparisonRule)
        {
            Argument.AssertNotNull(scalingMetric, nameof(scalingMetric));
            Argument.AssertNotNull(comparisonRule, nameof(comparisonRule));

            ActionType = actionType;
            EvaluationCount = evaluationCount;
            ScalingMetric = scalingMetric;
            ComparisonRule = comparisonRule;
        }

        /// <summary> Initializes a new instance of <see cref="ScalingRule"/>. </summary>
        /// <param name="actionType"> The action type. </param>
        /// <param name="evaluationCount"> This is an evaluation count for a scaling condition, the number of times a trigger condition should be successful, before scaling activity is triggered. </param>
        /// <param name="scalingMetric"> Metrics name for individual workloads. For example: cpu. </param>
        /// <param name="comparisonRule"> The comparison rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScalingRule(ScaleActionType actionType, int evaluationCount, string scalingMetric, HDInsightComparisonRule comparisonRule, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActionType = actionType;
            EvaluationCount = evaluationCount;
            ScalingMetric = scalingMetric;
            ComparisonRule = comparisonRule;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ScalingRule"/> for deserialization. </summary>
        internal ScalingRule()
        {
        }

        /// <summary> The action type. </summary>
        [WirePath("actionType")]
        public ScaleActionType ActionType { get; set; }
        /// <summary> This is an evaluation count for a scaling condition, the number of times a trigger condition should be successful, before scaling activity is triggered. </summary>
        [WirePath("evaluationCount")]
        public int EvaluationCount { get; set; }
        /// <summary> Metrics name for individual workloads. For example: cpu. </summary>
        [WirePath("scalingMetric")]
        public string ScalingMetric { get; set; }
        /// <summary> The comparison rule. </summary>
        [WirePath("comparisonRule")]
        public HDInsightComparisonRule ComparisonRule { get; set; }
    }
}
