// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties required to describe audit log storage. </summary>
    internal partial class RangerAuditSpec
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RangerAuditSpec"/>. </summary>
        public RangerAuditSpec()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RangerAuditSpec"/>. </summary>
        /// <param name="storageAccount"> Azure storage location of the blobs. MSI should have read/write access to this Storage account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RangerAuditSpec(string storageAccount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageAccount = storageAccount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Azure storage location of the blobs. MSI should have read/write access to this Storage account. </summary>
        [WirePath("storageAccount")]
        public string StorageAccount { get; set; }
    }
}
