// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The RangerAdminSpecDatabase. </summary>
    public partial class RangerAdminSpecDatabase
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RangerAdminSpecDatabase"/>. </summary>
        /// <param name="host"> The database URL. </param>
        /// <param name="name"> The database name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="host"/> or <paramref name="name"/> is null. </exception>
        public RangerAdminSpecDatabase(string host, string name)
        {
            Argument.AssertNotNull(host, nameof(host));
            Argument.AssertNotNull(name, nameof(name));

            Host = host;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="RangerAdminSpecDatabase"/>. </summary>
        /// <param name="host"> The database URL. </param>
        /// <param name="name"> The database name. </param>
        /// <param name="passwordSecretRef"> Reference for the database password. </param>
        /// <param name="username"> The name of the database user. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RangerAdminSpecDatabase(string host, string name, string passwordSecretRef, string username, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Host = host;
            Name = name;
            PasswordSecretRef = passwordSecretRef;
            Username = username;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RangerAdminSpecDatabase"/> for deserialization. </summary>
        internal RangerAdminSpecDatabase()
        {
        }

        /// <summary> The database URL. </summary>
        [WirePath("host")]
        public string Host { get; set; }
        /// <summary> The database name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Reference for the database password. </summary>
        [WirePath("passwordSecretRef")]
        public string PasswordSecretRef { get; set; }
        /// <summary> The name of the database user. </summary>
        [WirePath("username")]
        public string Username { get; set; }
    }
}
