// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> This can only be set at cluster pool creation time and cannot be changed later. </summary>
    public readonly partial struct OutboundType : IEquatable<OutboundType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OutboundType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OutboundType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LoadBalancerValue = "loadBalancer";
        private const string UserDefinedRoutingValue = "userDefinedRouting";

        /// <summary> The load balancer is used for egress through an AKS assigned public IP. This supports Kubernetes services of type 'loadBalancer'. </summary>
        public static OutboundType LoadBalancer { get; } = new OutboundType(LoadBalancerValue);
        /// <summary> Egress paths must be defined by the user. This is an advanced scenario and requires proper network configuration. </summary>
        public static OutboundType UserDefinedRouting { get; } = new OutboundType(UserDefinedRoutingValue);
        /// <summary> Determines if two <see cref="OutboundType"/> values are the same. </summary>
        public static bool operator ==(OutboundType left, OutboundType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OutboundType"/> values are not the same. </summary>
        public static bool operator !=(OutboundType left, OutboundType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OutboundType"/>. </summary>
        public static implicit operator OutboundType(string value) => new OutboundType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OutboundType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OutboundType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
