// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </summary>
    public readonly partial struct MetastoreDBConnectionAuthenticationMode : IEquatable<MetastoreDBConnectionAuthenticationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetastoreDBConnectionAuthenticationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetastoreDBConnectionAuthenticationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlAuthValue = "SqlAuth";
        private const string IdentityAuthValue = "IdentityAuth";

        /// <summary> The password-based authentication to connect to your Hive metastore database. </summary>
        public static MetastoreDBConnectionAuthenticationMode SqlAuth { get; } = new MetastoreDBConnectionAuthenticationMode(SqlAuthValue);
        /// <summary> The managed-identity-based authentication to connect to your Hive metastore database. </summary>
        public static MetastoreDBConnectionAuthenticationMode IdentityAuth { get; } = new MetastoreDBConnectionAuthenticationMode(IdentityAuthValue);
        /// <summary> Determines if two <see cref="MetastoreDBConnectionAuthenticationMode"/> values are the same. </summary>
        public static bool operator ==(MetastoreDBConnectionAuthenticationMode left, MetastoreDBConnectionAuthenticationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetastoreDBConnectionAuthenticationMode"/> values are not the same. </summary>
        public static bool operator !=(MetastoreDBConnectionAuthenticationMode left, MetastoreDBConnectionAuthenticationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetastoreDBConnectionAuthenticationMode"/>. </summary>
        public static implicit operator MetastoreDBConnectionAuthenticationMode(string value) => new MetastoreDBConnectionAuthenticationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetastoreDBConnectionAuthenticationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetastoreDBConnectionAuthenticationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
