// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The details of managed identity. </summary>
    internal partial class ManagedIdentityProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedIdentityProfile"/>. </summary>
        /// <param name="identityList"> The list of managed identity. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="identityList"/> is null. </exception>
        public ManagedIdentityProfile(IEnumerable<HDInsightManagedIdentitySpec> identityList)
        {
            Argument.AssertNotNull(identityList, nameof(identityList));

            IdentityList = identityList.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedIdentityProfile"/>. </summary>
        /// <param name="identityList"> The list of managed identity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedIdentityProfile(IList<HDInsightManagedIdentitySpec> identityList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IdentityList = identityList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedIdentityProfile"/> for deserialization. </summary>
        internal ManagedIdentityProfile()
        {
        }

        /// <summary> The list of managed identity. </summary>
        [WirePath("identityList")]
        public IList<HDInsightManagedIdentitySpec> IdentityList { get; }
    }
}
