// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Type of key vault object: secret, key or certificate. </summary>
    public readonly partial struct KeyVaultObjectType : IEquatable<KeyVaultObjectType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KeyVaultObjectType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KeyVaultObjectType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string KeyValue = "Key";
        private const string SecretValue = "Secret";
        private const string CertificateValue = "Certificate";

        /// <summary> Key. </summary>
        public static KeyVaultObjectType Key { get; } = new KeyVaultObjectType(KeyValue);
        /// <summary> Secret. </summary>
        public static KeyVaultObjectType Secret { get; } = new KeyVaultObjectType(SecretValue);
        /// <summary> Certificate. </summary>
        public static KeyVaultObjectType Certificate { get; } = new KeyVaultObjectType(CertificateValue);
        /// <summary> Determines if two <see cref="KeyVaultObjectType"/> values are the same. </summary>
        public static bool operator ==(KeyVaultObjectType left, KeyVaultObjectType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KeyVaultObjectType"/> values are not the same. </summary>
        public static bool operator !=(KeyVaultObjectType left, KeyVaultObjectType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KeyVaultObjectType"/>. </summary>
        public static implicit operator KeyVaultObjectType(string value) => new KeyVaultObjectType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KeyVaultObjectType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KeyVaultObjectType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
