// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The Kafka cluster profile. </summary>
    public partial class KafkaProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KafkaProfile"/>. </summary>
        /// <param name="diskStorage"> Kafka disk storage profile. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="diskStorage"/> is null. </exception>
        public KafkaProfile(DiskStorageProfile diskStorage)
        {
            Argument.AssertNotNull(diskStorage, nameof(diskStorage));

            DiskStorage = diskStorage;
        }

        /// <summary> Initializes a new instance of <see cref="KafkaProfile"/>. </summary>
        /// <param name="isKRaftEnabled"> Expose Kafka cluster in KRaft mode. </param>
        /// <param name="isPublicEndpointsEnabled"> Expose worker nodes as public endpoints. </param>
        /// <param name="remoteStorageUriString"> Fully qualified path of Azure Storage container used for Tiered Storage. </param>
        /// <param name="diskStorage"> Kafka disk storage profile. </param>
        /// <param name="connectivityEndpoints"> Kafka bootstrap server and brokers related connectivity endpoints. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KafkaProfile(bool? isKRaftEnabled, bool? isPublicEndpointsEnabled, string remoteStorageUriString, DiskStorageProfile diskStorage, KafkaConnectivityEndpoints connectivityEndpoints, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsKRaftEnabled = isKRaftEnabled;
            IsPublicEndpointsEnabled = isPublicEndpointsEnabled;
            RemoteStorageUriString = remoteStorageUriString;
            DiskStorage = diskStorage;
            ConnectivityEndpoints = connectivityEndpoints;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KafkaProfile"/> for deserialization. </summary>
        internal KafkaProfile()
        {
        }

        /// <summary> Expose Kafka cluster in KRaft mode. </summary>
        [WirePath("enableKRaft")]
        public bool? IsKRaftEnabled { get; set; }
        /// <summary> Expose worker nodes as public endpoints. </summary>
        [WirePath("enablePublicEndpoints")]
        public bool? IsPublicEndpointsEnabled { get; set; }
        /// <summary> Fully qualified path of Azure Storage container used for Tiered Storage. </summary>
        [WirePath("remoteStorageUri")]
        public string RemoteStorageUriString { get; set; }
        /// <summary> Kafka disk storage profile. </summary>
        [WirePath("diskStorage")]
        public DiskStorageProfile DiskStorage { get; set; }
        /// <summary> Kafka bootstrap server and brokers related connectivity endpoints. </summary>
        [WirePath("connectivityEndpoints")]
        public KafkaConnectivityEndpoints ConnectivityEndpoints { get; }
    }
}
