// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Hive Catalog Option. </summary>
    public partial class HiveCatalogOption
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HiveCatalogOption"/>. </summary>
        /// <param name="catalogName"> Name of trino catalog which should use specified hive metastore. </param>
        /// <param name="metastoreDBConnectionUriString"> Connection string for hive metastore database. </param>
        /// <param name="metastoreWarehouseDir"> Metastore root directory URI, format: abfs[s]://&lt;container&gt;@&lt;account_name&gt;.dfs.core.windows.net/&lt;path&gt;. More details: https://docs.microsoft.com/en-us/azure/storage/blobs/data-lake-storage-introduction-abfs-uri. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="catalogName"/>, <paramref name="metastoreDBConnectionUriString"/> or <paramref name="metastoreWarehouseDir"/> is null. </exception>
        public HiveCatalogOption(string catalogName, string metastoreDBConnectionUriString, string metastoreWarehouseDir)
        {
            Argument.AssertNotNull(catalogName, nameof(catalogName));
            Argument.AssertNotNull(metastoreDBConnectionUriString, nameof(metastoreDBConnectionUriString));
            Argument.AssertNotNull(metastoreWarehouseDir, nameof(metastoreWarehouseDir));

            CatalogName = catalogName;
            MetastoreDBConnectionUriString = metastoreDBConnectionUriString;
            MetastoreWarehouseDir = metastoreWarehouseDir;
        }

        /// <summary> Initializes a new instance of <see cref="HiveCatalogOption"/>. </summary>
        /// <param name="catalogName"> Name of trino catalog which should use specified hive metastore. </param>
        /// <param name="metastoreDBConnectionAuthenticationMode"> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </param>
        /// <param name="metastoreDBConnectionPasswordSecret"> Secret reference name from secretsProfile.secrets containing password for database connection. </param>
        /// <param name="metastoreDBConnectionUriString"> Connection string for hive metastore database. </param>
        /// <param name="metastoreDBConnectionUserName"> User name for database connection. </param>
        /// <param name="metastoreWarehouseDir"> Metastore root directory URI, format: abfs[s]://&lt;container&gt;@&lt;account_name&gt;.dfs.core.windows.net/&lt;path&gt;. More details: https://docs.microsoft.com/en-us/azure/storage/blobs/data-lake-storage-introduction-abfs-uri. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HiveCatalogOption(string catalogName, MetastoreDBConnectionAuthenticationMode? metastoreDBConnectionAuthenticationMode, string metastoreDBConnectionPasswordSecret, string metastoreDBConnectionUriString, string metastoreDBConnectionUserName, string metastoreWarehouseDir, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CatalogName = catalogName;
            MetastoreDBConnectionAuthenticationMode = metastoreDBConnectionAuthenticationMode;
            MetastoreDBConnectionPasswordSecret = metastoreDBConnectionPasswordSecret;
            MetastoreDBConnectionUriString = metastoreDBConnectionUriString;
            MetastoreDBConnectionUserName = metastoreDBConnectionUserName;
            MetastoreWarehouseDir = metastoreWarehouseDir;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HiveCatalogOption"/> for deserialization. </summary>
        internal HiveCatalogOption()
        {
        }

        /// <summary> Name of trino catalog which should use specified hive metastore. </summary>
        [WirePath("catalogName")]
        public string CatalogName { get; set; }
        /// <summary> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </summary>
        [WirePath("metastoreDbConnectionAuthenticationMode")]
        public MetastoreDBConnectionAuthenticationMode? MetastoreDBConnectionAuthenticationMode { get; set; }
        /// <summary> Secret reference name from secretsProfile.secrets containing password for database connection. </summary>
        [WirePath("metastoreDbConnectionPasswordSecret")]
        public string MetastoreDBConnectionPasswordSecret { get; set; }
        /// <summary> Connection string for hive metastore database. </summary>
        [WirePath("metastoreDbConnectionURL")]
        public string MetastoreDBConnectionUriString { get; set; }
        /// <summary> User name for database connection. </summary>
        [WirePath("metastoreDbConnectionUserName")]
        public string MetastoreDBConnectionUserName { get; set; }
        /// <summary> Metastore root directory URI, format: abfs[s]://&lt;container&gt;@&lt;account_name&gt;.dfs.core.windows.net/&lt;path&gt;. More details: https://docs.microsoft.com/en-us/azure/storage/blobs/data-lake-storage-introduction-abfs-uri. </summary>
        [WirePath("metastoreWarehouseDir")]
        public string MetastoreWarehouseDir { get; set; }
    }
}
