// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The type of managed identity. </summary>
    public readonly partial struct HDInsightManagedIdentityType : IEquatable<HDInsightManagedIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HDInsightManagedIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HDInsightManagedIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClusterValue = "cluster";
        private const string UserValue = "user";
        private const string InternalValue = "internal";

        /// <summary> cluster. </summary>
        public static HDInsightManagedIdentityType Cluster { get; } = new HDInsightManagedIdentityType(ClusterValue);
        /// <summary> user. </summary>
        public static HDInsightManagedIdentityType User { get; } = new HDInsightManagedIdentityType(UserValue);
        /// <summary> internal. </summary>
        public static HDInsightManagedIdentityType Internal { get; } = new HDInsightManagedIdentityType(InternalValue);
        /// <summary> Determines if two <see cref="HDInsightManagedIdentityType"/> values are the same. </summary>
        public static bool operator ==(HDInsightManagedIdentityType left, HDInsightManagedIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HDInsightManagedIdentityType"/> values are not the same. </summary>
        public static bool operator !=(HDInsightManagedIdentityType left, HDInsightManagedIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HDInsightManagedIdentityType"/>. </summary>
        public static implicit operator HDInsightManagedIdentityType(string value) => new HDInsightManagedIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HDInsightManagedIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HDInsightManagedIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
