// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The details of a managed identity. </summary>
    public partial class HDInsightManagedIdentitySpec
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightManagedIdentitySpec"/>. </summary>
        /// <param name="identityType"> The type of managed identity. </param>
        /// <param name="resourceId"> ResourceId of the managed identity. </param>
        /// <param name="clientId"> ClientId of the managed identity. </param>
        /// <param name="objectId"> ObjectId of the managed identity. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/>, <paramref name="clientId"/> or <paramref name="objectId"/> is null. </exception>
        public HDInsightManagedIdentitySpec(HDInsightManagedIdentityType identityType, ResourceIdentifier resourceId, string clientId, string objectId)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNull(clientId, nameof(clientId));
            Argument.AssertNotNull(objectId, nameof(objectId));

            IdentityType = identityType;
            ResourceId = resourceId;
            ClientId = clientId;
            ObjectId = objectId;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightManagedIdentitySpec"/>. </summary>
        /// <param name="identityType"> The type of managed identity. </param>
        /// <param name="resourceId"> ResourceId of the managed identity. </param>
        /// <param name="clientId"> ClientId of the managed identity. </param>
        /// <param name="objectId"> ObjectId of the managed identity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightManagedIdentitySpec(HDInsightManagedIdentityType identityType, ResourceIdentifier resourceId, string clientId, string objectId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IdentityType = identityType;
            ResourceId = resourceId;
            ClientId = clientId;
            ObjectId = objectId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightManagedIdentitySpec"/> for deserialization. </summary>
        internal HDInsightManagedIdentitySpec()
        {
        }

        /// <summary> The type of managed identity. </summary>
        [WirePath("type")]
        public HDInsightManagedIdentityType IdentityType { get; set; }
        /// <summary> ResourceId of the managed identity. </summary>
        [WirePath("resourceId")]
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> ClientId of the managed identity. </summary>
        [WirePath("clientId")]
        public string ClientId { get; set; }
        /// <summary> ObjectId of the managed identity. </summary>
        [WirePath("objectId")]
        public string ObjectId { get; set; }
    }
}
