// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Identity Profile with details of an MSI. </summary>
    public partial class HDInsightIdentityProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightIdentityProfile"/>. </summary>
        /// <param name="msiResourceId"> ResourceId of the MSI. </param>
        /// <param name="msiClientId"> ClientId of the MSI. </param>
        /// <param name="msiObjectId"> ObjectId of the MSI. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="msiResourceId"/>, <paramref name="msiClientId"/> or <paramref name="msiObjectId"/> is null. </exception>
        public HDInsightIdentityProfile(ResourceIdentifier msiResourceId, string msiClientId, string msiObjectId)
        {
            Argument.AssertNotNull(msiResourceId, nameof(msiResourceId));
            Argument.AssertNotNull(msiClientId, nameof(msiClientId));
            Argument.AssertNotNull(msiObjectId, nameof(msiObjectId));

            MsiResourceId = msiResourceId;
            MsiClientId = msiClientId;
            MsiObjectId = msiObjectId;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightIdentityProfile"/>. </summary>
        /// <param name="msiResourceId"> ResourceId of the MSI. </param>
        /// <param name="msiClientId"> ClientId of the MSI. </param>
        /// <param name="msiObjectId"> ObjectId of the MSI. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightIdentityProfile(ResourceIdentifier msiResourceId, string msiClientId, string msiObjectId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MsiResourceId = msiResourceId;
            MsiClientId = msiClientId;
            MsiObjectId = msiObjectId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightIdentityProfile"/> for deserialization. </summary>
        internal HDInsightIdentityProfile()
        {
        }

        /// <summary> ResourceId of the MSI. </summary>
        [WirePath("msiResourceId")]
        public ResourceIdentifier MsiResourceId { get; set; }
        /// <summary> ClientId of the MSI. </summary>
        [WirePath("msiClientId")]
        public string MsiClientId { get; set; }
        /// <summary> ObjectId of the MSI. </summary>
        [WirePath("msiObjectId")]
        public string MsiObjectId { get; set; }
    }
}
