// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The comparison operator. </summary>
    public readonly partial struct HDInsightComparisonOperator : IEquatable<HDInsightComparisonOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HDInsightComparisonOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HDInsightComparisonOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GreaterThanValue = "greaterThan";
        private const string GreaterThanOrEqualValue = "greaterThanOrEqual";
        private const string LessThanValue = "lessThan";
        private const string LessThanOrEqualValue = "lessThanOrEqual";

        /// <summary> greaterThan. </summary>
        public static HDInsightComparisonOperator GreaterThan { get; } = new HDInsightComparisonOperator(GreaterThanValue);
        /// <summary> greaterThanOrEqual. </summary>
        public static HDInsightComparisonOperator GreaterThanOrEqual { get; } = new HDInsightComparisonOperator(GreaterThanOrEqualValue);
        /// <summary> lessThan. </summary>
        public static HDInsightComparisonOperator LessThan { get; } = new HDInsightComparisonOperator(LessThanValue);
        /// <summary> lessThanOrEqual. </summary>
        public static HDInsightComparisonOperator LessThanOrEqual { get; } = new HDInsightComparisonOperator(LessThanOrEqualValue);
        /// <summary> Determines if two <see cref="HDInsightComparisonOperator"/> values are the same. </summary>
        public static bool operator ==(HDInsightComparisonOperator left, HDInsightComparisonOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HDInsightComparisonOperator"/> values are not the same. </summary>
        public static bool operator !=(HDInsightComparisonOperator left, HDInsightComparisonOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HDInsightComparisonOperator"/>. </summary>
        public static implicit operator HDInsightComparisonOperator(string value) => new HDInsightComparisonOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HDInsightComparisonOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HDInsightComparisonOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
