// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster resource properties. </summary>
    public partial class HDInsightClusterProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterProperties"/>. </summary>
        /// <param name="clusterType"> The type of cluster. </param>
        /// <param name="computeProfile"> The compute profile. </param>
        /// <param name="clusterProfile"> Cluster profile. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clusterType"/>, <paramref name="computeProfile"/> or <paramref name="clusterProfile"/> is null. </exception>
        public HDInsightClusterProperties(string clusterType, ClusterComputeProfile computeProfile, ClusterProfile clusterProfile)
        {
            Argument.AssertNotNull(clusterType, nameof(clusterType));
            Argument.AssertNotNull(computeProfile, nameof(computeProfile));
            Argument.AssertNotNull(clusterProfile, nameof(clusterProfile));

            ClusterType = clusterType;
            ComputeProfile = computeProfile;
            ClusterProfile = clusterProfile;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="clusterType"> The type of cluster. </param>
        /// <param name="deploymentId"> A unique id generated by the RP to identify the resource. </param>
        /// <param name="computeProfile"> The compute profile. </param>
        /// <param name="clusterProfile"> Cluster profile. </param>
        /// <param name="status"> Business status of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightClusterProperties(HDInsightProvisioningStatus? provisioningState, string clusterType, string deploymentId, ClusterComputeProfile computeProfile, ClusterProfile clusterProfile, string status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            ClusterType = clusterType;
            DeploymentId = deploymentId;
            ComputeProfile = computeProfile;
            ClusterProfile = clusterProfile;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterProperties"/> for deserialization. </summary>
        internal HDInsightClusterProperties()
        {
        }

        /// <summary> Provisioning state of the resource. </summary>
        [WirePath("provisioningState")]
        public HDInsightProvisioningStatus? ProvisioningState { get; }
        /// <summary> The type of cluster. </summary>
        [WirePath("clusterType")]
        public string ClusterType { get; set; }
        /// <summary> A unique id generated by the RP to identify the resource. </summary>
        [WirePath("deploymentId")]
        public string DeploymentId { get; }
        /// <summary> The compute profile. </summary>
        [WirePath("computeProfile")]
        public ClusterComputeProfile ComputeProfile { get; set; }
        /// <summary> Cluster profile. </summary>
        [WirePath("clusterProfile")]
        public ClusterProfile ClusterProfile { get; set; }
        /// <summary> Business status of the resource. </summary>
        [WirePath("status")]
        public string Status { get; }
    }
}
