// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster pool resource properties. </summary>
    public partial class HDInsightClusterPoolProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterPoolProperties"/>. </summary>
        /// <param name="computeProfile"> CLuster pool compute profile. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="computeProfile"/> is null. </exception>
        public HDInsightClusterPoolProperties(ClusterPoolComputeProfile computeProfile)
        {
            Argument.AssertNotNull(computeProfile, nameof(computeProfile));

            ComputeProfile = computeProfile;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterPoolProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="deploymentId"> A unique id generated by the RP to identify the resource. </param>
        /// <param name="managedResourceGroupName"> A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction. </param>
        /// <param name="aksManagedResourceGroupName"> A resource group created by AKS, to hold the infrastructure resources created by AKS on-behalf of customers. It is generated by cluster pool name and managed resource group name by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. </param>
        /// <param name="clusterPoolProfile"> CLuster pool profile. </param>
        /// <param name="computeProfile"> CLuster pool compute profile. </param>
        /// <param name="aksClusterProfile"> Properties of underlying AKS cluster. </param>
        /// <param name="networkProfile"> Cluster pool network profile. </param>
        /// <param name="logAnalyticsProfile"> Cluster pool log analytics profile to enable OMS agent for AKS cluster. </param>
        /// <param name="status"> Business status of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightClusterPoolProperties(HDInsightProvisioningStatus? provisioningState, string deploymentId, string managedResourceGroupName, string aksManagedResourceGroupName, ClusterPoolProfile clusterPoolProfile, ClusterPoolComputeProfile computeProfile, AksClusterProfile aksClusterProfile, ClusterPoolNetworkProfile networkProfile, ClusterPoolLogAnalyticsProfile logAnalyticsProfile, string status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            DeploymentId = deploymentId;
            ManagedResourceGroupName = managedResourceGroupName;
            AksManagedResourceGroupName = aksManagedResourceGroupName;
            ClusterPoolProfile = clusterPoolProfile;
            ComputeProfile = computeProfile;
            AksClusterProfile = aksClusterProfile;
            NetworkProfile = networkProfile;
            LogAnalyticsProfile = logAnalyticsProfile;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterPoolProperties"/> for deserialization. </summary>
        internal HDInsightClusterPoolProperties()
        {
        }

        /// <summary> Provisioning state of the resource. </summary>
        [WirePath("provisioningState")]
        public HDInsightProvisioningStatus? ProvisioningState { get; }
        /// <summary> A unique id generated by the RP to identify the resource. </summary>
        [WirePath("deploymentId")]
        public string DeploymentId { get; }
        /// <summary> A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction. </summary>
        [WirePath("managedResourceGroupName")]
        public string ManagedResourceGroupName { get; set; }
        /// <summary> A resource group created by AKS, to hold the infrastructure resources created by AKS on-behalf of customers. It is generated by cluster pool name and managed resource group name by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. </summary>
        [WirePath("aksManagedResourceGroupName")]
        public string AksManagedResourceGroupName { get; }
        /// <summary> CLuster pool profile. </summary>
        internal ClusterPoolProfile ClusterPoolProfile { get; set; }
        /// <summary> Cluster pool version is a 2-part version. </summary>
        [WirePath("clusterPoolProfile.clusterPoolVersion")]
        public string ClusterPoolVersion
        {
            get => ClusterPoolProfile is null ? default : ClusterPoolProfile.ClusterPoolVersion;
            set => ClusterPoolProfile = new ClusterPoolProfile(value);
        }

        /// <summary> CLuster pool compute profile. </summary>
        [WirePath("computeProfile")]
        public ClusterPoolComputeProfile ComputeProfile { get; set; }
        /// <summary> Properties of underlying AKS cluster. </summary>
        [WirePath("aksClusterProfile")]
        public AksClusterProfile AksClusterProfile { get; }
        /// <summary> Cluster pool network profile. </summary>
        [WirePath("networkProfile")]
        public ClusterPoolNetworkProfile NetworkProfile { get; set; }
        /// <summary> Cluster pool log analytics profile to enable OMS agent for AKS cluster. </summary>
        [WirePath("logAnalyticsProfile")]
        public ClusterPoolLogAnalyticsProfile LogAnalyticsProfile { get; set; }
        /// <summary> Business status of the resource. </summary>
        [WirePath("status")]
        public string Status { get; }
    }
}
