// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class HDInsightClusterPoolProperties : IUtf8JsonSerializable, IJsonModel<HDInsightClusterPoolProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HDInsightClusterPoolProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HDInsightClusterPoolProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightClusterPoolProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightClusterPoolProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DeploymentId))
            {
                writer.WritePropertyName("deploymentId"u8);
                writer.WriteStringValue(DeploymentId);
            }
            if (Optional.IsDefined(ManagedResourceGroupName))
            {
                writer.WritePropertyName("managedResourceGroupName"u8);
                writer.WriteStringValue(ManagedResourceGroupName);
            }
            if (options.Format != "W" && Optional.IsDefined(AksManagedResourceGroupName))
            {
                writer.WritePropertyName("aksManagedResourceGroupName"u8);
                writer.WriteStringValue(AksManagedResourceGroupName);
            }
            if (Optional.IsDefined(ClusterPoolProfile))
            {
                writer.WritePropertyName("clusterPoolProfile"u8);
                writer.WriteObjectValue(ClusterPoolProfile, options);
            }
            writer.WritePropertyName("computeProfile"u8);
            writer.WriteObjectValue(ComputeProfile, options);
            if (options.Format != "W" && Optional.IsDefined(AksClusterProfile))
            {
                writer.WritePropertyName("aksClusterProfile"u8);
                writer.WriteObjectValue(AksClusterProfile, options);
            }
            if (Optional.IsDefined(NetworkProfile))
            {
                writer.WritePropertyName("networkProfile"u8);
                writer.WriteObjectValue(NetworkProfile, options);
            }
            if (Optional.IsDefined(LogAnalyticsProfile))
            {
                writer.WritePropertyName("logAnalyticsProfile"u8);
                writer.WriteObjectValue(LogAnalyticsProfile, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HDInsightClusterPoolProperties IJsonModel<HDInsightClusterPoolProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightClusterPoolProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightClusterPoolProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHDInsightClusterPoolProperties(document.RootElement, options);
        }

        internal static HDInsightClusterPoolProperties DeserializeHDInsightClusterPoolProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            HDInsightProvisioningStatus? provisioningState = default;
            string deploymentId = default;
            string managedResourceGroupName = default;
            string aksManagedResourceGroupName = default;
            ClusterPoolProfile clusterPoolProfile = default;
            ClusterPoolComputeProfile computeProfile = default;
            AksClusterProfile aksClusterProfile = default;
            ClusterPoolNetworkProfile networkProfile = default;
            ClusterPoolLogAnalyticsProfile logAnalyticsProfile = default;
            string status = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new HDInsightProvisioningStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("deploymentId"u8))
                {
                    deploymentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("managedResourceGroupName"u8))
                {
                    managedResourceGroupName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("aksManagedResourceGroupName"u8))
                {
                    aksManagedResourceGroupName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clusterPoolProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clusterPoolProfile = ClusterPoolProfile.DeserializeClusterPoolProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("computeProfile"u8))
                {
                    computeProfile = ClusterPoolComputeProfile.DeserializeClusterPoolComputeProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("aksClusterProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    aksClusterProfile = AksClusterProfile.DeserializeAksClusterProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("networkProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    networkProfile = ClusterPoolNetworkProfile.DeserializeClusterPoolNetworkProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("logAnalyticsProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    logAnalyticsProfile = ClusterPoolLogAnalyticsProfile.DeserializeClusterPoolLogAnalyticsProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HDInsightClusterPoolProperties(
                provisioningState,
                deploymentId,
                managedResourceGroupName,
                aksManagedResourceGroupName,
                clusterPoolProfile,
                computeProfile,
                aksClusterProfile,
                networkProfile,
                logAnalyticsProfile,
                status,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("  provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DeploymentId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  deploymentId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DeploymentId))
                {
                    builder.Append("  deploymentId: ");
                    if (DeploymentId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DeploymentId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DeploymentId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ManagedResourceGroupName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  managedResourceGroupName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ManagedResourceGroupName))
                {
                    builder.Append("  managedResourceGroupName: ");
                    if (ManagedResourceGroupName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ManagedResourceGroupName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ManagedResourceGroupName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AksManagedResourceGroupName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  aksManagedResourceGroupName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AksManagedResourceGroupName))
                {
                    builder.Append("  aksManagedResourceGroupName: ");
                    if (AksManagedResourceGroupName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AksManagedResourceGroupName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AksManagedResourceGroupName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("ClusterPoolVersion", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterPoolProfile: ");
                builder.AppendLine("{");
                builder.Append("    clusterPoolVersion: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(ClusterPoolProfile))
                {
                    builder.Append("  clusterPoolProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ClusterPoolProfile, options, 2, false, "  clusterPoolProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ComputeProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  computeProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ComputeProfile))
                {
                    builder.Append("  computeProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ComputeProfile, options, 2, false, "  computeProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AksClusterProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  aksClusterProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AksClusterProfile))
                {
                    builder.Append("  aksClusterProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AksClusterProfile, options, 2, false, "  aksClusterProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  networkProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkProfile))
                {
                    builder.Append("  networkProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, NetworkProfile, options, 2, false, "  networkProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LogAnalyticsProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  logAnalyticsProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LogAnalyticsProfile))
                {
                    builder.Append("  logAnalyticsProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LogAnalyticsProfile, options, 2, false, "  logAnalyticsProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("  status: ");
                    if (Status.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Status}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Status}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HDInsightClusterPoolProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightClusterPoolProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HDInsightClusterPoolProperties)} does not support writing '{options.Format}' format.");
            }
        }

        HDInsightClusterPoolProperties IPersistableModel<HDInsightClusterPoolProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightClusterPoolProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHDInsightClusterPoolProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HDInsightClusterPoolProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HDInsightClusterPoolProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
