// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The Flink cluster profile. </summary>
    public partial class FlinkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FlinkProfile"/>. </summary>
        /// <param name="storage"> The storage profile. </param>
        /// <param name="jobManager"> Job Manager container/ process CPU and memory requirements. </param>
        /// <param name="taskManager"> Task Manager container/ process CPU and memory requirements. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storage"/>, <paramref name="jobManager"/> or <paramref name="taskManager"/> is null. </exception>
        public FlinkProfile(FlinkStorageProfile storage, ComputeResourceRequirement jobManager, ComputeResourceRequirement taskManager)
        {
            Argument.AssertNotNull(storage, nameof(storage));
            Argument.AssertNotNull(jobManager, nameof(jobManager));
            Argument.AssertNotNull(taskManager, nameof(taskManager));

            Storage = storage;
            JobManager = jobManager;
            TaskManager = taskManager;
        }

        /// <summary> Initializes a new instance of <see cref="FlinkProfile"/>. </summary>
        /// <param name="storage"> The storage profile. </param>
        /// <param name="numReplicas"> The number of task managers. </param>
        /// <param name="jobManager"> Job Manager container/ process CPU and memory requirements. </param>
        /// <param name="historyServer"> History Server container/ process CPU and memory requirements. </param>
        /// <param name="taskManager"> Task Manager container/ process CPU and memory requirements. </param>
        /// <param name="catalogOptions"> Flink cluster catalog options. </param>
        /// <param name="deploymentMode"> A string property that indicates the deployment mode of Flink cluster. It can have one of the following enum values =&gt; Application, Session. Default value is Session. </param>
        /// <param name="jobSpec"> Job specifications for flink clusters in application deployment mode. The specification is immutable even if job properties are changed by calling the RunJob API, please use the ListJob API to get the latest job information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FlinkProfile(FlinkStorageProfile storage, int? numReplicas, ComputeResourceRequirement jobManager, ComputeResourceRequirement historyServer, ComputeResourceRequirement taskManager, FlinkCatalogOptions catalogOptions, DeploymentMode? deploymentMode, FlinkJobProfile jobSpec, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Storage = storage;
            NumReplicas = numReplicas;
            JobManager = jobManager;
            HistoryServer = historyServer;
            TaskManager = taskManager;
            CatalogOptions = catalogOptions;
            DeploymentMode = deploymentMode;
            JobSpec = jobSpec;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FlinkProfile"/> for deserialization. </summary>
        internal FlinkProfile()
        {
        }

        /// <summary> The storage profile. </summary>
        [WirePath("storage")]
        public FlinkStorageProfile Storage { get; set; }
        /// <summary> The number of task managers. </summary>
        [WirePath("numReplicas")]
        public int? NumReplicas { get; set; }
        /// <summary> Job Manager container/ process CPU and memory requirements. </summary>
        [WirePath("jobManager")]
        public ComputeResourceRequirement JobManager { get; set; }
        /// <summary> History Server container/ process CPU and memory requirements. </summary>
        [WirePath("historyServer")]
        public ComputeResourceRequirement HistoryServer { get; set; }
        /// <summary> Task Manager container/ process CPU and memory requirements. </summary>
        [WirePath("taskManager")]
        public ComputeResourceRequirement TaskManager { get; set; }
        /// <summary> Flink cluster catalog options. </summary>
        internal FlinkCatalogOptions CatalogOptions { get; set; }
        /// <summary> Hive Catalog Option for Flink cluster. </summary>
        [WirePath("catalogOptions.hive")]
        public FlinkHiveCatalogOption CatalogOptionsHive
        {
            get => CatalogOptions is null ? default : CatalogOptions.Hive;
            set
            {
                if (CatalogOptions is null)
                    CatalogOptions = new FlinkCatalogOptions();
                CatalogOptions.Hive = value;
            }
        }

        /// <summary> A string property that indicates the deployment mode of Flink cluster. It can have one of the following enum values =&gt; Application, Session. Default value is Session. </summary>
        [WirePath("deploymentMode")]
        public DeploymentMode? DeploymentMode { get; set; }
        /// <summary> Job specifications for flink clusters in application deployment mode. The specification is immutable even if job properties are changed by calling the RunJob API, please use the ListJob API to get the latest job information. </summary>
        [WirePath("jobSpec")]
        public FlinkJobProfile JobSpec { get; set; }
    }
}
