// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class FlinkProfile : IUtf8JsonSerializable, IJsonModel<FlinkProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FlinkProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FlinkProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FlinkProfile)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("storage"u8);
            writer.WriteObjectValue(Storage, options);
            if (Optional.IsDefined(NumReplicas))
            {
                writer.WritePropertyName("numReplicas"u8);
                writer.WriteNumberValue(NumReplicas.Value);
            }
            writer.WritePropertyName("jobManager"u8);
            writer.WriteObjectValue(JobManager, options);
            if (Optional.IsDefined(HistoryServer))
            {
                writer.WritePropertyName("historyServer"u8);
                writer.WriteObjectValue(HistoryServer, options);
            }
            writer.WritePropertyName("taskManager"u8);
            writer.WriteObjectValue(TaskManager, options);
            if (Optional.IsDefined(CatalogOptions))
            {
                writer.WritePropertyName("catalogOptions"u8);
                writer.WriteObjectValue(CatalogOptions, options);
            }
            if (Optional.IsDefined(DeploymentMode))
            {
                writer.WritePropertyName("deploymentMode"u8);
                writer.WriteStringValue(DeploymentMode.Value.ToString());
            }
            if (Optional.IsDefined(JobSpec))
            {
                writer.WritePropertyName("jobSpec"u8);
                writer.WriteObjectValue(JobSpec, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FlinkProfile IJsonModel<FlinkProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FlinkProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFlinkProfile(document.RootElement, options);
        }

        internal static FlinkProfile DeserializeFlinkProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FlinkStorageProfile storage = default;
            int? numReplicas = default;
            ComputeResourceRequirement jobManager = default;
            ComputeResourceRequirement historyServer = default;
            ComputeResourceRequirement taskManager = default;
            FlinkCatalogOptions catalogOptions = default;
            DeploymentMode? deploymentMode = default;
            FlinkJobProfile jobSpec = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("storage"u8))
                {
                    storage = FlinkStorageProfile.DeserializeFlinkStorageProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("numReplicas"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numReplicas = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("jobManager"u8))
                {
                    jobManager = ComputeResourceRequirement.DeserializeComputeResourceRequirement(property.Value, options);
                    continue;
                }
                if (property.NameEquals("historyServer"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    historyServer = ComputeResourceRequirement.DeserializeComputeResourceRequirement(property.Value, options);
                    continue;
                }
                if (property.NameEquals("taskManager"u8))
                {
                    taskManager = ComputeResourceRequirement.DeserializeComputeResourceRequirement(property.Value, options);
                    continue;
                }
                if (property.NameEquals("catalogOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    catalogOptions = FlinkCatalogOptions.DeserializeFlinkCatalogOptions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("deploymentMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deploymentMode = new DeploymentMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("jobSpec"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jobSpec = FlinkJobProfile.DeserializeFlinkJobProfile(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FlinkProfile(
                storage,
                numReplicas,
                jobManager,
                historyServer,
                taskManager,
                catalogOptions,
                deploymentMode,
                jobSpec,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Storage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Storage))
                {
                    builder.Append("  storage: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Storage, options, 2, false, "  storage: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumReplicas), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  numReplicas: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumReplicas))
                {
                    builder.Append("  numReplicas: ");
                    builder.AppendLine($"{NumReplicas.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(JobManager), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  jobManager: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(JobManager))
                {
                    builder.Append("  jobManager: ");
                    BicepSerializationHelpers.AppendChildObject(builder, JobManager, options, 2, false, "  jobManager: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HistoryServer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  historyServer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HistoryServer))
                {
                    builder.Append("  historyServer: ");
                    BicepSerializationHelpers.AppendChildObject(builder, HistoryServer, options, 2, false, "  historyServer: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TaskManager), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  taskManager: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TaskManager))
                {
                    builder.Append("  taskManager: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TaskManager, options, 2, false, "  taskManager: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("CatalogOptionsHive", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  catalogOptions: ");
                builder.AppendLine("{");
                builder.Append("    hive: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(CatalogOptions))
                {
                    builder.Append("  catalogOptions: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CatalogOptions, options, 2, false, "  catalogOptions: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DeploymentMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  deploymentMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DeploymentMode))
                {
                    builder.Append("  deploymentMode: ");
                    builder.AppendLine($"'{DeploymentMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(JobSpec), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  jobSpec: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(JobSpec))
                {
                    builder.Append("  jobSpec: ");
                    BicepSerializationHelpers.AppendChildObject(builder, JobSpec, options, 2, false, "  jobSpec: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FlinkProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FlinkProfile)} does not support writing '{options.Format}' format.");
            }
        }

        FlinkProfile IPersistableModel<FlinkProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFlinkProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FlinkProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FlinkProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
