// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Job specifications for flink clusters in application deployment mode. The specification is immutable even if job properties are changed by calling the RunJob API, please use the ListJob API to get the latest job information. </summary>
    public partial class FlinkJobProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FlinkJobProfile"/>. </summary>
        /// <param name="jobJarDirectory"> A string property that specifies the directory where the job JAR is located. </param>
        /// <param name="jarName"> A string property that represents the name of the job JAR. </param>
        /// <param name="upgradeMode"> A string property that indicates the upgrade mode to be performed on the Flink job. It can have one of the following enum values =&gt; STATELESS_UPDATE, UPDATE, LAST_STATE_UPDATE. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobJarDirectory"/> or <paramref name="jarName"/> is null. </exception>
        public FlinkJobProfile(string jobJarDirectory, string jarName, UpgradeMode upgradeMode)
        {
            Argument.AssertNotNull(jobJarDirectory, nameof(jobJarDirectory));
            Argument.AssertNotNull(jarName, nameof(jarName));

            JobJarDirectory = jobJarDirectory;
            JarName = jarName;
            UpgradeMode = upgradeMode;
        }

        /// <summary> Initializes a new instance of <see cref="FlinkJobProfile"/>. </summary>
        /// <param name="jobJarDirectory"> A string property that specifies the directory where the job JAR is located. </param>
        /// <param name="jarName"> A string property that represents the name of the job JAR. </param>
        /// <param name="entryClass"> A string property that specifies the entry class for the Flink job. If not specified, the entry point is auto-detected from the flink job jar package. </param>
        /// <param name="args"> A string property representing additional JVM arguments for the Flink job. It should be space separated value. </param>
        /// <param name="savePointName"> A string property that represents the name of the savepoint for the Flink job. </param>
        /// <param name="upgradeMode"> A string property that indicates the upgrade mode to be performed on the Flink job. It can have one of the following enum values =&gt; STATELESS_UPDATE, UPDATE, LAST_STATE_UPDATE. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FlinkJobProfile(string jobJarDirectory, string jarName, string entryClass, string args, string savePointName, UpgradeMode upgradeMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            JobJarDirectory = jobJarDirectory;
            JarName = jarName;
            EntryClass = entryClass;
            Args = args;
            SavePointName = savePointName;
            UpgradeMode = upgradeMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FlinkJobProfile"/> for deserialization. </summary>
        internal FlinkJobProfile()
        {
        }

        /// <summary> A string property that specifies the directory where the job JAR is located. </summary>
        [WirePath("jobJarDirectory")]
        public string JobJarDirectory { get; set; }
        /// <summary> A string property that represents the name of the job JAR. </summary>
        [WirePath("jarName")]
        public string JarName { get; set; }
        /// <summary> A string property that specifies the entry class for the Flink job. If not specified, the entry point is auto-detected from the flink job jar package. </summary>
        [WirePath("entryClass")]
        public string EntryClass { get; set; }
        /// <summary> A string property representing additional JVM arguments for the Flink job. It should be space separated value. </summary>
        [WirePath("args")]
        public string Args { get; set; }
        /// <summary> A string property that represents the name of the savepoint for the Flink job. </summary>
        [WirePath("savePointName")]
        public string SavePointName { get; set; }
        /// <summary> A string property that indicates the upgrade mode to be performed on the Flink job. It can have one of the following enum values =&gt; STATELESS_UPDATE, UPDATE, LAST_STATE_UPDATE. </summary>
        [WirePath("upgradeMode")]
        public UpgradeMode UpgradeMode { get; set; }
    }
}
