// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class FlinkJobProfile : IUtf8JsonSerializable, IJsonModel<FlinkJobProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FlinkJobProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FlinkJobProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkJobProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FlinkJobProfile)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("jobJarDirectory"u8);
            writer.WriteStringValue(JobJarDirectory);
            writer.WritePropertyName("jarName"u8);
            writer.WriteStringValue(JarName);
            if (Optional.IsDefined(EntryClass))
            {
                writer.WritePropertyName("entryClass"u8);
                writer.WriteStringValue(EntryClass);
            }
            if (Optional.IsDefined(Args))
            {
                writer.WritePropertyName("args"u8);
                writer.WriteStringValue(Args);
            }
            if (Optional.IsDefined(SavePointName))
            {
                writer.WritePropertyName("savePointName"u8);
                writer.WriteStringValue(SavePointName);
            }
            writer.WritePropertyName("upgradeMode"u8);
            writer.WriteStringValue(UpgradeMode.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FlinkJobProfile IJsonModel<FlinkJobProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkJobProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FlinkJobProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFlinkJobProfile(document.RootElement, options);
        }

        internal static FlinkJobProfile DeserializeFlinkJobProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string jobJarDirectory = default;
            string jarName = default;
            string entryClass = default;
            string args = default;
            string savePointName = default;
            UpgradeMode upgradeMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("jobJarDirectory"u8))
                {
                    jobJarDirectory = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("jarName"u8))
                {
                    jarName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("entryClass"u8))
                {
                    entryClass = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("args"u8))
                {
                    args = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("savePointName"u8))
                {
                    savePointName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("upgradeMode"u8))
                {
                    upgradeMode = new UpgradeMode(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FlinkJobProfile(
                jobJarDirectory,
                jarName,
                entryClass,
                args,
                savePointName,
                upgradeMode,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(JobJarDirectory), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  jobJarDirectory: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(JobJarDirectory))
                {
                    builder.Append("  jobJarDirectory: ");
                    if (JobJarDirectory.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{JobJarDirectory}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{JobJarDirectory}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(JarName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  jarName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(JarName))
                {
                    builder.Append("  jarName: ");
                    if (JarName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{JarName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{JarName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EntryClass), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  entryClass: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EntryClass))
                {
                    builder.Append("  entryClass: ");
                    if (EntryClass.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EntryClass}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EntryClass}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Args), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  args: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Args))
                {
                    builder.Append("  args: ");
                    if (Args.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Args}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Args}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SavePointName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  savePointName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SavePointName))
                {
                    builder.Append("  savePointName: ");
                    if (SavePointName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SavePointName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SavePointName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UpgradeMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  upgradeMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  upgradeMode: ");
                builder.AppendLine($"'{UpgradeMode.ToString()}'");
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FlinkJobProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkJobProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FlinkJobProfile)} does not support writing '{options.Format}' format.");
            }
        }

        FlinkJobProfile IPersistableModel<FlinkJobProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FlinkJobProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFlinkJobProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FlinkJobProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FlinkJobProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
